package gov.va.med.mhv.admin.converter;

import java.util.ArrayList;
import java.util.List;

import org.springframework.stereotype.Component;

import gov.va.med.mhv.admin.dto.VisnDTO;
import gov.va.med.mhv.admin.model.Visn;

@Component
public class VisnConverter  {

	public static VisnDTO convert(Visn source) {
		VisnDTO target = new VisnDTO();

		target.setVisnId(source.getVisnId());
		target.setVisnName(source.getVisnName());

		return target;
	}

	public static Visn convert(VisnDTO source) {
		Visn target = new Visn();

		target.setVisnId(source.getVisnId());
		target.setVisnName(source.getVisnName());

		return target;
	}
	
	public static List<VisnDTO> convertVisns(List<Visn> visns){
		List<VisnDTO> visnDtos = new ArrayList<VisnDTO>();
		for(Visn visn :visns){
			visnDtos.add(convert(visn));
		}
		return visnDtos;
	}
}
